% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[3.68244	66.31784	214.31539	361.00304	461.88134	501.27504	477.44048	384.7	234.93997	80.4585	18.82179	54.2127	93.8042	90.26151	40.16394	-6.31188E-14;
43.42982	71.96163	199.31579	339.51522	437.89466	476.932	452.14767	359.94308	216.18644	83.69106	56.12299	110.87212	157.23134	155.14206	100.47194	41.00675;
137.37485	90.45609	158.7901	276.12249	367.79709	404.07649	377.51786	288.40769	165.36271	94.55671	138.4332	228.30071	286.47858	285.58471	224.72792	132.46743;
234.97114	118.09188	103.27019	180.21073	257.9156	289.25318	260.19354	179.27762	97.81936	112.59321	222.49782	335.37751	400.29676	400.91221	337.82101	224.0985;
302.07159	145.18586	53.78807	78.20958	136.9728	161.78131	131.96003	65.57823	39.15182	129.79604	279.29591	403.35301	469.61495	471.66015	408.55229	286.02547;
324.29148	156.78467	34.23688	30.25989	76.8583	98.46974	69.40526	12.70231	16.85668	136.89486	298.18973	425.00961	491.57631	493.33126	431.21187	306.40334;
298.48912	145.12996	56.08214	80.30854	139.12658	165.40356	135.65914	67.16548	39.95109	130.07876	277.18836	399.1422	465.1069	466.77101	404.43877	283.76204;
230.32442	118.44771	105.86311	184.13827	264.57151	298.04622	268.75491	183.99207	100.08655	113.42956	219.43673	328.67645	391.53652	392.52069	331.16294	221.09278;
133.99072	89.28809	160.2075	280.06562	374.70403	412.49166	385.22729	294.00848	168.42594	95.53013	136.46163	221.56148	277.72264	277.2921	219.43834	130.81568;
41.55769	70.59153	200.22901	341.7034	442.13933	481.6142	455.5662	362.61878	217.79573	83.71524	54.31214	107.696	153.57308	150.80762	98.27086	41.99254;
3.68244	64.8053	214.61316	360.91865	461.90015	500.60638	475.32808	383.28313	233.8698	79.77157	17.29152	52.67221	93.45267	88.8984	39.94518	1.70174]'/1E3;
 
    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=0;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=2.932;
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=23.1;
    poisson_ratio=0.383;
 
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=2;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=1/2*BurVect;
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.0;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        % LatC_spacing=sqrt(2/3)/2*BurVect;
        % [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
        %                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    % dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='FALSE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    % Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    % eb_input=[];
    % es_input=[];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    % LatC_spacing=[];

        % % % >>> for FCC structure

        % LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    % coefV=[];

        % % % >>> for FCC structure
    
        % coefV=3/4*(sqrt(2)*BurVect)^3;
    
    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    % wc_range=[];
      
    % % Concentration of solute atom
 
    % solute_concentration=1;
